

<?php $__env->startSection('title'); ?>
    Message
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">

<link rel="stylesheet" href="<?php echo e(asset('backend/plugins/select2/css/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('backend/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Message</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">All Message</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-7 col-7">
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title">All Message</h3>
                    </div>
                    <div class="card-body">
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="20%">To User</th>
                                    
                                    <th>Message</th>
                                    <th width="15%">Date</th>
                                    <th width="10%">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key + 1); ?></td>
                                        <td><?php echo e(user_name($data->user_id)); ?><br><small><?php echo e(user_code($data->user_id)); ?></small></td>
                                        
                                        <td><b><?php echo e($data->message_title); ?></b><br><?php echo e($data->message); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($data->created_at)->format('j M Y')); ?></td>
                                        <td>
                                            <button type="button" onclick="deleteData(<?php echo e($data->id); ?>)" class="btn btn-danger btn-sm">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                            <form id="delete-form-<?php echo e($data->id); ?>" action="<?php echo e(route('admin.user-message.delete', $data->id)); ?>" method="POST" style="display: none;">
                                                <?php echo csrf_field(); ?>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 col-5">
                <form action="<?php echo e(route('admin.user-message.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">New Message</h3>
                        </div>
                        <div class="card-body row">
                            <div class="form-group col-lg-12 col-md-12 col-12">
                                <label for="user_id">User *</label>
                                <select class="form-control select2" name="user_id" style="width: 100%;">
                                    <option value="">Select One</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?> - ID:<?php echo e($user->code); ?> </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-lg-12 col-md-12 col-12">
                                <label for="message">Message *</label>
                                <textarea class="form-control" name="message" id="message" cols="30" rows="4" required></textarea>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Send</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
<!-- Select2 -->
<script src="<?php echo e(asset('backend/plugins/select2/js/select2.full.min.js')); ?>"></script>

<script>
    $(function() {
    $("#example1").DataTable({
        "responsive": true,
        "autoWidth": false,
        "pageLength": 300,
    });
    $('#example2').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
    });
});

    $(function () {
        $('.select2').select2();
    });

    function deleteData(id) {
        if (confirm("Are you sure?")) {
            document.getElementById('delete-form-' + id).submit();
        }
        return false;
    }

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asditzone/public_html/resources/views/backend/pages/system-setting/user-message.blade.php ENDPATH**/ ?>